<?php

############################################
# Wines      - A Mambo Wine Component      #
# based on AKOgallery and recipes          #
# Copyright (C) 2004  by Tommaso Tamantini #
# Homepage   : www.lagarlata.net		   #
# Version    : 1.1                         #
# License    : GNU GPL Public License      #
############################################



# Don't allow direct linking

defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );



# Variables - Don't change anything here!!!

require($mosConfig_absolute_path."/administrator/components/com_wines/config.wines.php");

$picturepath    = $mosConfig_live_site.$ag_pathimages."/";

$thumbnailpath  = $mosConfig_live_site.$ag_paththumbs."/";

$wineversion    = "Wines 1.1 by Tommaso Tamantini";

# Check for Editor rights
if($my->usertype == 'Editor' || $my->usertype == 'Administrator' || $my->usertype == 'Super Administrator' )
{
	$is_editor = true;
}
else
{
	$is_editor = false;
}

$is_user =  (strtolower($my->usertype) <> '');

// CHECK LANGUAGE

if (!defined( '_WINES_LANG_INCLUDED' )) 
{
	if (file_exists($mosConfig_absolute_path."/administrator/components/com_wines/language/".$mosConfig_lang.".php") ) 
	{ 
		include_once($mosConfig_absolute_path."/administrator/components/com_wines/language/".$mosConfig_lang.".php");
	} 
	else 
	{ 
		include_once($mosConfig_absolute_path."/administrator/components/com_wines/language/english.php");
	}
}



function editWine( $option, &$row, &$clist, &$imagelist, &$thumblist, $ag_pathimages, $ag_paththumbs ) {

	global $mosConfig_live_site,$wineversion;

?>

	

	<script language="JavaScript1.2" type="text/JavaScript1.2">

	<!--

		_editor_url = '<?php echo $mosConfig_live_site; ?>/editor/htmlarea2/';          // URL to htmlarea files

		//_editor_url = 'http://localhost/mambo/editor/htmlarea2/';      

		var win_ie_ver = parseFloat(navigator.appVersion.split("MSIE")[1]);

		if (navigator.userAgent.indexOf('Mac')        >= 0) { win_ie_ver = 0; }

		if (navigator.userAgent.indexOf('Windows CE') >= 0) { win_ie_ver = 0; }

		if (navigator.userAgent.indexOf('Opera')      >= 0) { win_ie_ver = 0; }

		

		if (win_ie_ver >= 5.5) {

			document.write('<scr' + 'ipt src="' + _editor_url + 'editor.js"');

			document.write(' language="Javascript1.2"></scr' + 'ipt>');

		} else {

			document.write('<scr'+'ipt>function editor_generate() { return false; }</scr'+'ipt>');

		}

	//-->

	</script>

    <script language="javascript" type="text/javascript">

    function submitbutton(pressbutton) {

      var form = document.adminForm;

      if (pressbutton == 'cancel') {

        submitform( pressbutton );

        return;

      }



      // do field validation

      if (form.imgtitle.value == ""){

        alert( "Item must have a title" );

      } else if (form.catid.value == "0"){

        alert( "You must select a category." );

      } else {

        submitform( pressbutton );

      }

    }

    </script>


	<form action="index.php?option=com_wines&func=save&Itemid=0" method="post" name="adminForm" id="adminForm">
    <table cellpadding="4" cellspacing="1" border="0" width="100%" class="adminform">

      <tr>

        <td width="20%" align="right"><?php echo _WINES_DT_NAME;?>:</td>

        <td width="80%">

          <input class="inputbox" type="text" name="imgtitle" size="50" maxlength="100" value="<?php echo htmlspecialchars( $row->imgtitle, ENT_QUOTES );?>" />

        </td>

      </tr>



      <tr>

        <td valign="top" align="right"><?php echo _WINES_ADMIN_CATEGORY;?>:</td>

        <td>

          <?php echo $clist; ?>

        </td>

      </tr>



      <tr>

        <td valign="top" align="right"><?php echo _WINES_DT_DESC;?>:</td>

        <td>

          <textarea class="inputbox" cols="50" rows="5" name="imgtext" style="width:500px" width="500"><?php echo htmlspecialchars( $row->imgtext, ENT_QUOTES );?></textarea>

			<script language="JavaScript1.2" defer="defer">

			<!--

				editor_generate('imgtext');

			//-->

			</script>                

		</td>

      </tr>

      <tr>

        <td valign="top" align="right"><?php echo _WINES_GRAPES;?>:</td>

        <td>

        

          <textarea class="inputbox" cols="50" rows="10" name="grapes" style="width:500px" width="500"><?php echo htmlspecialchars( $row->grapes, ENT_QUOTES );?></textarea>

          <script language="JavaScript1.2" defer="defer">

	<!--

		editor_generate('grapes');

	//-->

	</script>

        </td>

      </tr>      <tr>

        <td valign="top" align="right"><?php echo _WINES_PROPERTIES;?>:</td>

        <td>

          <textarea class="inputbox" cols="50" rows="15" name="properties" style="width:500px" width="500"><?php echo htmlspecialchars( $row->properties, ENT_QUOTES );?></textarea>

          <script language="JavaScript1.2" defer="defer">

             <!--

                editor_generate('properties');

             //-->

          </script>

        </td>

      </tr>      <tr>

        <td valign="top" align="right"><?php echo _WINES_NOTES;?>:</td>

        <td>

          <textarea class="inputbox" cols="50" rows="5" name="notes" style="width:500px" width="500"><?php echo htmlspecialchars( $row->notes, ENT_QUOTES );?></textarea>

        </td>

      </tr>

      <tr>

        <td valign="top" align="right"><?php echo _WINES_AUTHOR;?>:</td>

        <td>

          <input class="inputbox" type="text" name="imgauthor" value="<?php echo $row->imgauthor; ?>" size="50" maxlength="100" />

        </td>

      </tr>

      <tr>

        <td width="20%" align="right"><?php echo _WINES_ALCHOOL;?>:</td>

        <td width="80%">

          <input class="inputbox" type="text" name="alchool" size="20" maxlength="20" value="<?php echo htmlspecialchars( $row->alchool, ENT_QUOTES );?>" />

        </td>

      </tr>

      <tr>

        <td width="20%" align="right"><?php echo _WINES_AGING;?>:</td>

        <td width="80%">

          <input class="inputbox" type="text" name="aging" size="20" maxlength="20" value="<?php echo htmlspecialchars( $row->aging, ENT_QUOTES );?>" />

        </td>

      </tr>

      <tr>

        <td width="20%" align="right"><?php echo _WINES_YEAR;?>:</td>

        <td width="80%">

          <input class="inputbox" type="text" name="years" size="20" maxlength="20" value="<?php echo htmlspecialchars( $row->years, ENT_QUOTES );?>" />

        </td>

      </tr>

      <tr>

        <td width="20%" align="right"><?php echo _WINES_COUNTRY;?>:</td>

        <td width="80%">

          <input class="inputbox" type="text" name="country" size="20" maxlength="20" value="<?php echo htmlspecialchars( $row->country, ENT_QUOTES );?>" />

        </td>

      </tr>

      <tr>

        <td width="20%" align="right"><?php echo _WINES_PRICE;?>:</td>

        <td width="80%">

          <input class="inputbox" type="text" name="price" size="20" maxlength="20" value="<?php echo htmlspecialchars( $row->price, ENT_QUOTES );?>" />

        </td>

      </tr>

      <tr>

        <td width="20%" align="right"><?php echo _WINES_DOC;?>:</td>

        <td width="80%">

          <?php

	        $yesno[] = mosHTML::makeOption( '0', 'No' );

	        $yesno[] = mosHTML::makeOption( '1', 'Yes' );

	        $yn_ag_showdetail = mosHTML::selectList( $yesno, 'doc', 'class="inputbox" size="2"', 'value', 'text', $doc );

	        echo $yn_ag_showdetail;

          ?>

        </td>

      </tr>

	  <tr>

        <td width="20%" align="right">&nbsp;</td>

        <td width="80%">&nbsp;</td>

      </tr>      

	  <tr>

        <td width="20%" align="right">&nbsp;</td>

        <td width="80%">

		 <input type="submit" name="submit" value="<?php echo _WINES_SUBMIT;?>" class="button"/>

        </td>

      </tr>

    </table>



    <input type="hidden" name="id" value="<?php echo $row->id; ?>" />

    <input type="hidden" name="option" value="<?php echo $option;?>" />

    <input type="hidden" name="task" value="" />

   

	</form>

<?php

  }



function WineHeader($addOnOff) {

	global $database, $catid, $Itemid, $id, $is_editor, $ag_showrating, $ag_showcomment,$ag_postnewwine,$mosConfig_live_site;

	echo "<TABLE WIDTH='98%' CELLPADDING='3' CELLSPACING='4' BORDER='0' ALIGN='center' class='newspane'>";

	echo "<TR><TD CLASS='componentheading'>"._WINES_TITLE."</TD></TR>";

	echo "<TR><TD>";

	

	echo "<table width='100%' border='0' cellspacing='0' cellpadding='3'><tr>";

	echo "<td><img src='components/com_wines/images/home.gif' hspace='6' border='0' align='absmiddle'><a href='index.php?option=com_wines&Itemid=$Itemid'>"._WINES_CATEGORIES."</a>";

	if ($catid <> "") {

		$database->setQuery("SELECT title FROM #__categories WHERE id = '".$catid."'");

		$cattitle = $database->loadResult();

		echo " <img src='images/M_images/arrow.png'> $cattitle";

	} else if ($id) {

		$database->setQuery( "SELECT a.*, cc.title AS category"

		. "\nFROM #__wines AS a, #__categories AS cc"

		. "\nWHERE a.catid=cc.id AND a.id=$id" );

		$rows = $database->loadObjectList();

		$row = &$rows[0];

		echo " <img src='images/M_images/arrow.png' /> <a href='index.php?option=com_wines&Itemid=$Itemid&func=viewcategory&catid=$row->catid'>$row->category</A> <img src='images/M_images/arrow.png' /> $row->imgtitle ";

	}

	echo "</TD>";

	echo "<td align='right'>";

	echo "<FORM NAME='searchgalform' ACTION='index.php' TARGET=_top METHOD='POST'>";

	echo "<INPUT TYPE='hidden' NAME='option' value='com_wines'><INPUT TYPE='hidden' NAME='Itemid' value='$Itemid'>";

	echo "<INPUT TYPE='hidden' NAME='func' value='special'><INPUT TYPE='hidden' NAME='sorting' value='find'>";

	echo "<INPUT TYPE='text' NAME='sstring' style='border: 1px solid; font: 10px Arial' onBlur=\"if(this.value=='') this.value='"._WINES_SEARCHBOX."';\" onFocus=\"if(this.value=='"._WINES_SEARCHBOX."') this.value='';\" VALUE='"._WINES_SEARCHBOX."'></FORM>";

	echo "</TD>";

	echo "</TR></TABLE></TD></TR><TR><TD align='right'>";

	echo "<a href='index.php?option=com_wines&Itemid=$Itemid&func=special'>"._WINES_MOST_VIEWED."</a>";

	if ($ag_showrating) echo " - <a href='index.php?option=com_wines&Itemid=$Itemid&func=special&sorting=rating'>"._WINES_TOP_RATED."</a>";

	echo " - <a href='index.php?option=com_wines&Itemid=$Itemid&func=special&sorting=lastadd'>"._WINES_LAST_ADDED."</a>";

	if ($ag_showcomment) echo " - <a href='index.php?option=com_wines&Itemid=$Itemid&func=special&sorting=lastcomment'>"._WINES_LAST_COMMENTED."</a>";

	echo "</TD></TR><TR><TD>";
	echo "<div align='center'>";
	if($ag_postnewwine && $addOnOff) echo " <a href='index.php?option=com_wines&func=newItem'>"._WINES_ADD_WINE."</a>";
	echo "</div>";
	echo "</TD></TR><TR><TD>";
	return;

}

	

	function savePost()

	{

		global $database, $my, $fromUser, $is_editor;
		include('administrator/components/com_wines/class.wines.php');
		include('administrator/components/com_wines/config.wines.php');
		$newWine = new moswines($database);
		$newWine->price = mosGetParam( $_POST, "price", $newWine->price );	
		$newWine->imgtitle = mosGetParam( $_POST, "imgtitle", $newWine->imgtitle );	
		$newWine->catid = mosGetParam( $_POST, "catid", $newWine->catid );	
		$newWine->imgtext = mosGetParam( $_POST, "imgtext", $newWine->imgtext );	
		$newWine->grapes = mosGetParam( $_POST, "grapes", $newWine->grapes );	
		$newWine->properties = mosGetParam( $_POST, "properties", $newWine->properties );	
		$newWine->notes = mosGetParam( $_POST, "notes", $newWine->notes );	
		$newWine->imgauthor = mosGetParam( $_POST, "imgauthor", $newWine->imgauthor );	
		$newWine->alchool = mosGetParam( $_POST, "alchool", $newWine->alchool );	
		$newWine->aging = mosGetParam( $_POST, "aging", $newWine->aging );	
		$newWine->years = mosGetParam( $_POST, "years", $newWine->years );	
		$newWine->country = mosGetParam( $_POST, "country", $newWine->country );	
		$newWine->doc = mosGetParam( $_POST, "doc", $newWine->doc );	

		$newWine->published = 0;
		if($is_editor)
		{
			$newWine->published = 1;
		}
		
		#DATA VALIDATION 

		if ($newWine->imgtitle==null || $newWine->imgtitle=="" || $newWine->catid <=0)

		{
			echo "<script> alert('Please, type a name and choose a category'); window.history.go(-1); </script>\n";
			exit();
	  	}


		if (!$newWine->store()) 

		{
			echo "<script> alert('".$newWine->getError()."'); window.history.go(-1); </script>\n";
			exit();
	  	}

		if($is_editor)
		{
		
			echo "<br><br><div align='center'>"._WINES_ADD_SUCCESS_EDITOR."</div><br><br>";
		}
		else
		{
			echo "<br><br><div align='center'>"._WINES_ADD_SUCCESS."</div><br><br>";
		}

		// messaging for new items to administrators

		require_once( "components/com_messages/messages.class.php" );
		$msg = new mosMessage( $database );
		$database->setQuery( "SELECT id FROM #__users WHERE sendEmail='1'" );
		$users = $database->loadResultArray();
		foreach ($users as $user_id) 
		{
			if($my->id>0)
			{
				$msg->send( $my->id, $user_id, "New Wine FROM ".$my->username, sprintf( "New wine:".$newWine->imgtitle." FROM ". $my->username, $my->username, $newWine->imgtitle ) );
			}		
			else //messaggio da anonimo (utente non registrato)
			{
				$msg->send( $user_id, $user_id, "New Wine FROM Anonymous", sprintf( "New wine:".$newWine->imgtitle." FROM Anonymous", $my->username, $newWine->imgtitle ) );								
			}

		}

		

		if($ag_sendEmail>0 && $ag_sendEmailAddress<>"" && $ag_sendEmailAddress<>null)
		{
			if($my->id>0)
			{
				$fromUser=$my->username;
			}		
			else //messaggio da anonimo (utente non registrato)
			{
				$fromUser="Anonymous";
			}

			$subject = "New Wine FROM " . $fromUser;
			$message = "A new wine has been submitted: ". $newWine->imgtitle ."\r \n";
			$message .= "Please, check it out from the wine admin panel.\r \n \r \n";
			$headers = "From: $ag_sendEmailAddress\r\n";
			$headers .= "Reply-To: $ag_sendEmailAddress\r\n";
			$headers .= "X-Priority: 3\r\n";
			$headers .= "X-MSMail-Priority: Low\r\n";
			$headers .= "X-Mailer: Mambo Open Source 4.5\r\n";
			mail( $ag_sendEmailAddress, $subject, $message, $headers );
		}
	}

	

function WineFooter() {
	global $wineversion,$is_editor,$id,$wine_showlogo;
	echo "</TD></TR>";

	if ($is_editor) {
		if ($id) {
			echo "<tr><td align='right'><img src='components/com_wines/images/edit.gif' hspace='6' border='0' align='absmiddle'><a href='index.php?option=com_wines&Itemid=$Itemid&func=editpic&id=$id'>Edit Wine</a></TD></TR>";
		}
	}

	echo "</TABLE><center><span class='small'>";
	echo "	<table cellpadding='4' cellspacing='0' border='0' width='100%'>";
	echo "		<tr>";
	#show/hide wine logo
	if($wine_showlogo)
	{
		echo "	 <td><div align='center'><a href='http://www.lagarlata.net' target='_new'><img src='administrator/components/com_wines/images/logo_small.png'></a></div></td>";
	}
	else
	{
		echo "	<br>";
	}
	echo "		</tr>";
	echo "		<tr>";
	echo "			<td><div align='center'><font class='smalldark'><b><a href='mailto:postmaster@lagarlata.net'>".$wineversion."</a></b> - <a href='http://www.lagarlata.net' target='_new'>www.lagarlata.net</a>  </font></div></td>";
	echo "		</tr>";
	echo "	</table>";
    echo "</span></center>";
	return;

}



function bb_decode($text) {

	$text = nl2br($text);

	static $bbcode_tpl = array();

	static $patterns = array();

	static $replacements = array();

	

	// First: If there isn't a "[" and a "]" in the message, don't bother.

	if ((strpos($text, "[") === false || strpos($text, "]") === false))

	{

		return $text;

	}



	// [b] and [/b] for bolding text.

	$text = str_replace("[b]", '<b>', $text);

	$text = str_replace("[/b]", '</b>', $text);

	

	// [u] and [/u] for underlining text.

	$text = str_replace("[u]", '<u>', $text);

	$text = str_replace("[/u]", '</u>', $text);

	

	// [i] and [/i] for italicizing text.

	$text = str_replace("[i]", '<i>', $text);

	$text = str_replace("[/i]", '</i>', $text);

	

	if (!count($bbcode_tpl)) {

		// We do URLs in several different ways..

		$bbcode_tpl['url']  = '<span class="bblink"><a href="{URL}" target="_blank">{DESCRIPTION}</a></span>';

		$bbcode_tpl['email']= '<span class="bblink"><a href="mailto:{EMAIL}">{EMAIL}</a></span>';

		

		$bbcode_tpl['url1'] = str_replace('{URL}', '\\1\\2', $bbcode_tpl['url']);

		$bbcode_tpl['url1'] = str_replace('{DESCRIPTION}', '\\1\\2', $bbcode_tpl['url1']);

		

		$bbcode_tpl['url2'] = str_replace('{URL}', 'http://\\1', $bbcode_tpl['url']);

		$bbcode_tpl['url2'] = str_replace('{DESCRIPTION}', '\\1', $bbcode_tpl['url2']);

		

		$bbcode_tpl['url3'] = str_replace('{URL}', '\\1\\2', $bbcode_tpl['url']);

		$bbcode_tpl['url3'] = str_replace('{DESCRIPTION}', '\\3', $bbcode_tpl['url3']);

		

		$bbcode_tpl['url4'] = str_replace('{URL}', 'http://\\1', $bbcode_tpl['url']);

		$bbcode_tpl['url4'] = str_replace('{DESCRIPTION}', '\\2', $bbcode_tpl['url4']);

		

		$bbcode_tpl['email'] = str_replace('{EMAIL}', '\\1', $bbcode_tpl['email']);

		

		// [url]xxxx://www.phpbb.com[/url] code..

		$patterns[1] = "#\[url\]([a-z]+?://){1}([a-z0-9\-\.,\?!%\*_\#:;~\\&$@\/=\+\(\)]+)\[/url\]#si";

		$replacements[1] = $bbcode_tpl['url1'];

		

		// [url]www.phpbb.com[/url] code.. (no xxxx:// prefix).

		$patterns[2] = "#\[url\]([a-z0-9\-\.,\?!%\*_\#:;~\\&$@\/=\+\(\)]+)\[/url\]#si";

		$replacements[2] = $bbcode_tpl['url2'];

		

		// [url=xxxx://www.phpbb.com]phpBB[/url] code..

		$patterns[3] = "#\[url=([a-z]+?://){1}([a-z0-9\-\.,\?!%\*_\#:;~\\&$@\/=\+\(\)]+)\](.*?)\[/url\]#si";

		$replacements[3] = $bbcode_tpl['url3'];

		

		// [url=www.phpbb.com]phpBB[/url] code.. (no xxxx:// prefix).

		$patterns[4] = "#\[url=([a-z0-9\-\.,\?!%\*_\#:;~\\&$@\/=\+\(\)]+)\](.*?)\[/url\]#si";

		$replacements[4] = $bbcode_tpl['url4'];

		

		// [email]user@domain.tld[/email] code..

		$patterns[5] = "#\[email\]([a-z0-9\-_.]+?@[\w\-]+\.([\w\-\.]+\.)?[\w]+)\[/email\]#si";

		$replacements[5] = $bbcode_tpl['email'];

	}



	$text = preg_replace($patterns, $replacements, $text);



	return $text;

}



##############################################################



switch ($func) {

	case 'special':

		include('components/com_wines/sub_viewspecial.php');

		break;

	case 'detail':

		include('components/com_wines/sub_viewdetails.php');

		break;

	case 'vote':

		include('components/com_wines/sub_vote.php');

		break;

	case 'editpic':

		WineHeader(1);

		include('components/com_wines/sub_editdetails.php');

		break;

	case 'comment':

		include('components/com_wines/sub_comment.php');

		break;

	case 'newItem':

		WineHeader(0);	 
		if($ag_postnewwine)
		{
			# Get the list of categories
	
			$categories[] = mosHTML::makeOption( '0', 'Select Category' );
	
			$database->setQuery( "SELECT id AS value, title AS text FROM #__categories"
	
			. "\nWHERE section='com_wines' ORDER BY ordering" );
	
			$categories = array_merge( $categories, $database->loadObjectList() );
	
			$clist = mosHTML::selectList( $categories, 'catid', 'class="inputbox" size="1"', 'value', 'text', $catid );
	
			editWine($option,&$row, &$clist, &$imagelist, &$thumblist,$ag_pathimages, $ag_paththumbs);
		}
		else
		{
			echo "<table  class='sectiontableentry2' width='100%' border='0' cellspacing='1' cellpadding='4'>";
			echo "<tr><td colspan='3' class='sectiontableheader' width='100%'><div align='center'>"._WINES_CANNOT_ADD."</div></td></tr>";
			echo "</table>";
		}
		break;

	case 'save':

		WineHeader(1);

		savePost();

		break;

	case 'deletecomment':

		include('components/com_wines/sub_deletecomment.php');

		break;

	case 'viewcategory':

		WineHeader(1);

		# Feststellen der Anzahl der verfgbaren Datenstze

		$database->setQuery("SELECT count(id) FROM #__wines WHERE published = '1' AND catid = '".$catid."'");

		$count = $database->loadResult();

		# Berechnen der Gesamtseiten

		$gesamtseiten = floor($count / $ag_perpage);

		$seitenrest   = $count % $ag_perpage;

		if ($seitenrest>0) {

		 $gesamtseiten++;

		}

		# Feststellen der aktuellen Seite

		if (isset($startpage)) {

		 if ($startpage>$gesamtseiten) {

		   $startpage = $gesamtseiten;

		 } else if ($startpage<1) {

		   $startpage = 1;

		 }

		} else {

		 $startpage = 1;

		}

		$text = str_replace("#count", $count, _WINES_NUMBER_WINES);

		echo "<p>".$text."<br>";

		echo _WINES_PAGES.": ";

		# Ausgeben der Seite zurueck Funktion

		$seiterueck = $startpage - 1;

		if ($seiterueck>0) {

		  echo "<a href=index.php?option=com_wines&Itemid=$Itemid&func=viewcategory&catid=$catid&startpage=$seiterueck><b></b></a> ";

		  }

		#Ausgeben der einzelnen Seiten

		 for ($i=1; $i <= $gesamtseiten; $i++) {

		   if ($i==$startpage) {

			 echo "$i ";

		   } else {

			 echo "<a href=index.php?option=com_wines&Itemid=$Itemid&func=viewcategory&catid=$catid&startpage=$i>$i</a> ";

		   }

		 }

		# Ausgeben der Seite vorwrts Funktion

		$seitevor = $startpage + 1;

		if ($seitevor<=$gesamtseiten) {

		  echo "<a href=index.php?option=com_wines&Itemid=$Itemid&func=viewcategory&catid=$catid&startpage=$seitevor><b></b></a> ";

		  }

		# Limit und Seite Vor- & Rueckfunktionen

		$start = ( $startpage - 1 ) * $ag_perpage;

		echo "</p>";

	

		$database->setQuery("SELECT name FROM #__categories WHERE id = '".$catid."'");

		$catname = $database->loadResult();

		echo "<table  class='sectiontableentry2' width='100%' border='0' cellspacing='1' cellpadding='4'>";

		echo "<tr><td colspan='3' class='sectiontableheader' width='100%'>$catname</td></tr>";

	

		$query1="SELECT * FROM #__wines WHERE published = '1' AND catid = '".$catid."' ORDER BY id DESC LIMIT ".$start.",".$ag_perpage;

		$database->setQuery($query1);

		$rows = $database->loadObjectList();

	

		echo "<tr>";

		$rowcounter = 0;

		foreach($rows as $row1) {

		  if (($rowcounter%3==0) AND ($rowcounter<>0)) echo "</tr><tr>";

		  echo "<td class='sectiontableentry1' width='34%' align='left' valign='bottom'>";

		  echo "<img src='images\M_images\arrow.png'/><a href='index.php?option=com_wines&Itemid=$Itemid&func=detail&id=$row1->id'><b>$row1->imgtitle</b></a>";

		  if ($ag_showdetail) echo "<br />"._WINES_ADMIN_HITS.": $row1->imgcounter";

		  if ($ag_showrating) {

			if ($row1->imgvotes>0) {

			  $fimgvotesum = number_format($row1->imgvotesum/$row1->imgvotes,2,",",".");

			  $frating = "$fimgvotesum ($row1->imgvotes "._WINES_VOTES.")";

			} else {

			  $frating = _WINES_NO_VOTES;

			}

			echo "<br />"._WINES_RATING.": $frating";

		  }

		  if ($ag_showcomment) {

			# Check how many comments exist

			$comments_query  = "SELECT cmtid FROM ".$mosConfig_dbprefix."wines_comments WHERE cmtpic='$row1->id'";

			$comments_result = $database->openConnectionWithReturn($comments_query);

			$comments        = mysql_num_rows($comments_result);

			echo "<br />"._WINES_DEL_COMMENT.": $comments";

		  }

		  echo "</td>";

		  $rowcounter++;

		}

		if ($rowcounter%3<>0) {

		  for ($i = 1; $i <= (3-($rowcounter%3)); $i++) {

			echo "<td class='sectiontableentry1' width='34%' valign='top'> </td>";

		  }

		}

		echo "</tr></table>";

		break;

		#########################################################################################

  default:

		WineHeader(1);

		echo "<table width='100%' border='0' cellspacing='1' cellpadding='4'>";

		echo "<tr><td class='sectiontableheader' width='100%'>"._WINES_CATEGORIES."</td></tr>";

	

		$query1="SELECT * FROM #__categories WHERE section = 'com_wines' AND published = '1' ORDER BY ordering ASC";

		$database->setQuery($query1);

		$rows = $database->loadObjectList();

	

		$line=1;

		foreach($rows as $row1) {

		  $linecolor = ($line % 2) + 1;

		  echo "<tr class='sectiontableentry".$linecolor."'><td width='100%' valign='top'>";

		  if ($row1->image <> "") {

			echo "<a href=index.php?option=com_wines&Itemid=$Itemid&func=viewcategory&catid=$row1->id>";

			echo "<img src='images/stories/$row1->image' align='$row1->image_position' hspace='4' border='0'/></a>";

		  }

	

		  $database->setQuery("SELECT count(id) FROM #__wines WHERE published = '1' AND catid = '".$row1->id."'");

		  $count = $database->loadResult();

	

		  echo "<img src='images/M_images/arrow.png' /><a href=index.php?option=com_wines&Itemid=$Itemid&func=viewcategory&catid=$row1->id><b>$row1->title</b></a> ($count)";

		  if ($row1->description <> "") {

			echo "<br/>$row1->description";

		  }

		  echo "</tr>";

		  $line++;

		}

		echo "</tr></table>";

		break;

}



WineFooter();

?>